using Eco.MVC;
using Eco.ViewModel.Runtime;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.HttpsPolicy;
using Microsoft.AspNetCore.Mvc.ModelBinding;
using Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;

namespace WebApplication10
{
  public class Startup
  {
    public Startup(IWebHostEnvironment env, IConfiguration configuration) //added to inject the IWebHostEnvironment, needed for files
    {
      _HostingEnvironment = env;
      Configuration = configuration;
    }

    private IWebHostEnvironment _HostingEnvironment;


    public IConfiguration Configuration { get; }

    // This method gets called by the runtime. Use this method to add services to the container.
    public void ConfigureServices(IServiceCollection services)
    {
      services.AddControllersWithViews();
      services.AddMemoryCache(); // to hold shelved ecospaces
      var mvc = services.AddMvc(options =>
      { 
        options.ModelMetadataDetailsProviders.Add(new SuppressChildValidationMetadataProvider(typeof(VMClass))); // to avoid validation of the complete world by following VMClass refs
      }); 
      mvc.AddSessionStateTempDataProvider();
      services.AddSession(); // To hold selection etc during roundtrip

      services.Configure<MvcRazorRuntimeCompilationOptions>(options => {   // Needed to generate Razor for ViewModels
        options.FileProviders.Clear();
        options.FileProviders.Add(new MDrivenMVCCoreFileProvider(this._HostingEnvironment.ContentRootFileProvider, Directory.GetCurrentDirectory()));
      });

      services.AddRazorPages().AddRazorRuntimeCompilation(); //without AddRazorRuntimeCompilation our fileProvider is not called;

    }

    // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
    public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
    {
      if (env.IsDevelopment())
      {
        app.UseDeveloperExceptionPage();
      }
      else
      {
        app.UseExceptionHandler("/Home/Error");
        // The default HSTS value is 30 days. You may want to change this for production scenarios, see https://aka.ms/aspnetcore-hsts.
        app.UseHsts();
      }
      app.UseHttpsRedirection();
      app.UseStaticFiles();
      app.UseSession(); // to hold vm vars during MVC roundtrip

      app.UseRouting();

      app.UseAuthorization();



      app.UseEndpoints(endpoints =>
      {
        endpoints.MapControllerRoute(
                  name: "default",
                  pattern: "{controller=Home}/{action=Index}/{id?}");
      });
    }
  }
}
