﻿using ClassLibrary6;
using ClassLibrary6.ViewModelCodeGen_SampleViewModel;
using Eco.MVC;
using Eco.ObjectRepresentation;
using Eco.ViewModel.Runtime;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.Extensions.Caching.Memory;
using Package1;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace WebApplication10.Controllers
{
  public class StronglyTypedViewModelController : ModelDrivenControllerBase<EcoSpace1>
  {
    public StronglyTypedViewModelController(IMemoryCache memoryCache) : base(memoryCache)
    {
      this.ViewName = "View";
      this.DisplayActionName = "View";
    }

    public override VMClass ReCreateVMClass(string viewmodelname, IEcoObject root)
    {
      return SampleViewModel.Create(this.EcoSpace, root.AsIObject().AsObject as Package1.Class1);
    }

    public IActionResult Index()
    {
      var root = new Package1.Class1(this.EcoSpace);
      this.CommitSkipValidate();
      return this.Display("SampleViewModel", root.ExternalId());
    }

    public IActionResult View(string view, string id)
    {
      return this.Display(view, id);
    }


    [HttpPost]
    public IActionResult View([ModelBinder(typeof(VMClassBinder))] SampleViewModel value,string id)
    {
      var online = this.DoSubmit(value);
      this.Commit(online);
      return View("View", online);
    }
  }


  public static class HtmlHelperPartialExtensions2
  {
    public static string GetRazorForSampleViewModel(this IHtmlHelper<SampleViewModel> htmlHelper)
    {
      return MvcRazorPartialView.GetRazorForViewModel(htmlHelper.ViewData.Model.ViewModelClass.ViewModel);
    }
  }



}
