using Eco.Handles;
using Eco.Linq;
using Eco.Persistence;
using Eco.Services;
using Eco.UmlCodeAttributes;
using Package1;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;

namespace ClassLibrary6
{
  [EcoSpace]
  [UmlTaggedValue("Eco.InitializeNullableStringsToNull", "true")]
  [UmlTaggedValue("Eco.GenerateMultiplicityConstraints", "true")]
  [EcoSpacePackage(typeof(Package1Package))] // Add packages this way
  public partial class EcoSpace1 : Eco.Handles.DefaultEcoSpace
  {

    #region Eco Managed code
    private static ITypeSystemService typeSystemProvider;
    #endregion Eco Managed code

    public EcoSpace1() : base()
    {
      this.PersistenceMapper = new PersistenceMapperXml() { FileName = @"c:\temp\MVCTempData.xml" }; // simple setup during dev
    }

    /// <summary>
    /// Persist all changes to the domain objects.
    /// </summary>
    /// <remarks>
    /// This function persists all changes to the eco space, including object creation,
    /// object manipulation, changed associations and object deletions. After invoking this method
    /// all undo information is removed.
    /// If the application does not have any persistence layer defined the operation does nothing.
    /// </remarks>
    public void UpdateDatabase()
    {
      if ((Persistence != null) && (DirtyList != null))
      {
        Persistence.UpdateDatabaseWithList(DirtyList.AllDirtyObjects());
      }
    }

    #region Eco Managed code
    public static new ITypeSystemService GetTypeSystemService()
    {
      if (typeSystemProvider == null)
      {
        lock (typeof(EcoSpace1))
        {
          if (typeSystemProvider == null)
            typeSystemProvider = MakeTypeService(typeof(EcoSpace1));
        }
      }

      return typeSystemProvider;
    }

    protected override ITypeSystemService GetTypeSystemProvider()
    {
      return EcoSpace1.GetTypeSystemService();
    }
    #endregion

    // Add user written methods here
  }
}
